/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.app.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthAppLoginService;
import com.zkteco.zkbiosecurity.system.app.vo.BaseAuthAppItem;
import com.zkteco.zkbiosecurity.system.service.BaseRegisterService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.service.ModuleInfoService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/app/v1"})
@ApiIgnore
public class BaseAuthAppLoginController {
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseRegisterService baseRegisterService;
    @Autowired
    private BaseAuthAppLoginService baseAuthAppLoginService;
    @Autowired
    private ModuleInfoService moduleInfoService;
    @Value(value="${socketio.url:127.0.0.1}")
    private String socketioUrl;
    @Value(value="${socketio.port:8098}")
    private String socketioPort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public String login(@RequestBody BaseAuthAppItem authAppItem) {
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)this.baseAuthAppLoginService.login(authAppItem).getData();
            return jsonObject;
        }
        catch (ZKBusinessException e) {
            jsonObject = new JSONObject();
            String msg = e.getMessage();
            String blank = "&nbsp";
            if (msg.indexOf(blank) >= 0) {
                msg = msg.substring(0, msg.indexOf(blank));
            }
            String ret = I18nUtil.i18nCode((String)msg, (Object[])new Object[0]);
            jsonObject.put("ret", (Object)ret);
        }
        finally {
            return jsonObject.toString();
        }
    }

    @RequestMapping(value={"/testConnect"}, method={RequestMethod.POST})
    public String testConnect() {
        JSONObject json = new JSONObject();
        json.put("ret", (Object)"OK");
        return json.toString();
    }

    @RequestMapping(value={"/appBinding"}, method={RequestMethod.POST})
    public String appBinding(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        String uuid = jsonObject.getString("uuid");
        if (StringUtils.isBlank((CharSequence)uuid)) {
            json.put("ret", (Object)"500");
            json.put("message", (Object)"uuid is null");
            return json.toString();
        }
        int ret = this.baseRegisterService.appBinding(jsonObject.getString("barcode"), uuid, jsonObject.getString("username"));
        if (ret == 200) {
            json.put("ret", (Object)"OK");
        } else {
            json.put("ret", (Object)String.valueOf(ret));
        }
        return json.toString();
    }

    @RequestMapping(value={"/queryMenus"}, method={RequestMethod.POST})
    public String queryMenus(@RequestBody BaseAuthAppItem authAppItem) {
        JSONObject json = new JSONObject();
        json.put("ret", (Object)"OK");
        json.put("menus", this.baseAuthAppLoginService.getMenus(authAppItem).getData());
        return json.toString();
    }

    @RequestMapping(value={"/getCurrentlanguage"}, method={RequestMethod.POST})
    public String getCurrentlanguage() {
        JSONObject json = new JSONObject();
        String currentlanguage = LocaleMessageSourceUtil.language;
        json.put("ret", (Object)"OK");
        json.put("currentlanguage", (Object)currentlanguage);
        return json.toString();
    }

    @RequestMapping(value={"/getCurrentVersion"}, method={RequestMethod.POST})
    public String getCurrentVersion() {
        JSONObject json = new JSONObject();
        String currentVersion = this.baseSysParamService.getValByName("systemVersion");
        json.put("ret", (Object)"OK");
        json.put("currentVersion", (Object)currentVersion);
        return json.toString();
    }

    @RequestMapping(value={"/getDictionary"}, method={RequestMethod.POST})
    public String getDictionary(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        json.put("ret", (Object)"OK");
        return json.toString();
    }

    @RequestMapping(value={"/editAppUser"}, method={RequestMethod.POST})
    public String editAppUser(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        this.baseAuthAppLoginService.editUser(jsonObject.getString("loginType"), jsonObject.getString("username"), jsonObject.getString("password"), jsonObject.getString("name"), jsonObject.getString("email"));
        json.put("ret", (Object)"OK");
        return json.toString();
    }

    @RequestMapping(value={"/getAppUser"}, method={RequestMethod.POST})
    public String getAppUser(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        json.put("ret", (Object)"OK");
        Map map = this.baseAuthAppLoginService.getAppUserInfo(jsonObject.getString("loginType"), jsonObject.getString("username"));
        json.put("data", (Object)map);
        return json.toString();
    }

    @RequestMapping(value={"/getSocketIoURL"}, method={RequestMethod.POST})
    public String getSocketIoURL() {
        JSONObject json = new JSONObject();
        json.put("ret", (Object)"OK");
        json.put("url", (Object)this.socketioUrl);
        json.put("port", (Object)this.socketioPort);
        return json.toString();
    }

    @RequestMapping(value={"/loginOut"}, method={RequestMethod.POST})
    public String loginOut(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        this.baseAuthAppLoginService.loginOut(jsonObject.getString("token"));
        json.put("ret", (Object)"OK");
        return json.toString();
    }

    @RequestMapping(value={"/getValueByKey"}, method={RequestMethod.POST})
    public String getValueByKey(@RequestBody JSONObject jsonObject) {
        JSONObject json = new JSONObject();
        JSONArray keys = jsonObject.getJSONArray("keys");
        HashMap<String, String> map1 = new HashMap<String, String>();
        if (!"".equals(keys) && keys != null) {
            for (int i = 0; i < keys.size(); ++i) {
                String value = this.baseSysParamService.getValByName(keys.getString(i));
                map1.put(keys.getString(i), value);
                if (!this.moduleInfoService.isExistModuleByCode("acc")) continue;
                map1.put("acc.version", "true");
            }
        }
        if (map1.isEmpty()) {
            json.put("ret", (Object)"no value");
        } else {
            json.put("ret", (Object)"OK");
            json.put("data", map1);
        }
        return json.toString();
    }
}

