/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.thread;

import com.alibaba.fastjson.JSONObject;
import com.google.common.primitives.Bytes;
import com.zkteco.zkbiosecurity.sis.router.SicmGateDevDataRouter;
import com.zkteco.zkbiosecurity.sis.service.SisDevCmdService;
import com.zkteco.zkbiosecurity.sis.websocket.SicmGateDeviceInfo;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SicmGateSocketThread
extends Thread {
    private static Logger logger = Logger.getLogger(SicmGateSocketThread.class);
    private Map<String, Socket> socketMap = new HashMap<String, Socket>();
    private List<SicmGateDeviceInfo> devInfoList = new ArrayList<SicmGateDeviceInfo>();
    Map<String, SicmGateDeviceInfo> allDevMap = null;
    InputStream inputStream = null;
    @Autowired
    SisDevCmdService sisDevCmdService;

    public SicmGateSocketThread(String threadName, Map<String, SicmGateDeviceInfo> allDevMap) {
        super.setName(threadName);
        this.allDevMap = allDevMap;
    }

    @Override
    public void run() {
        Boolean isException = true;
        while (isException.booleanValue()) {
            for (String key : this.allDevMap.keySet()) {
                SicmGateDeviceInfo device = this.allDevMap.get(key);
                Socket client = null;
                try {
                    client = device.getSocket();
                    this.inputStream = client.getInputStream();
                    byte[] buffer = new byte[1024];
                    int len = -1;
                    while ((len = this.inputStream.read(buffer)) != -1) {
                        this.receiveData(SicmGateSocketThread.subBytes(buffer, 0, len), device);
                    }
                }
                catch (Exception e) {
                    isException = false;
                    InetAddress address = client.getInetAddress();
                    String clientIp = address.getHostAddress();
                    SicmGateDeviceInfo.allGateDeviceMap.remove(clientIp);
                    logger.info((Object)("SicmGateSocketThread exception: " + e));
                }
            }
        }
    }

    public void receiveData(byte[] data, SicmGateDeviceInfo devInfo) {
        try {
            List mList = new ArrayList(Bytes.asList((byte[])data));
            while (mList.size() >= 6) {
                while ((Byte)mList.get(0) != -101 && (Byte)mList.get(0) != 104) {
                    mList.remove(0);
                    if (mList.size() != 0) continue;
                }
                if (mList.size() < 6) {
                    return;
                }
                int dataLen = (Byte)mList.get(5) + 7 - 51;
                if (mList.size() < dataLen) {
                    return;
                }
                byte[] realData = Bytes.toArray(mList.subList(0, dataLen));
                logger.info((Object)("\u5b89\u68c0\u95e8\u4e0a\u4f20\u7684\u6570\u636e===========" + Arrays.toString(realData)));
                this.dealDateFlow(realData, devInfo);
                mList = mList.subList(dataLen, mList.size());
            }
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
    }

    private void dealDateFlow(byte[] data, SicmGateDeviceInfo devInfo) {
        if (this.checkCS(data).booleanValue()) {
            String cmdType = Integer.toHexString(0xFF & data[6] - 51);
            switch (cmdType.toUpperCase()) {
                case "AD": {
                    SicmGateSocketThread.dealDevId(devInfo, data);
                    break;
                }
                case "33": {
                    SicmGateSocketThread.dealWorkParameters(devInfo, data);
                    break;
                }
                case "34": {
                    SicmGateSocketThread.dealAlarmLight(devInfo, data);
                    break;
                }
                case "44": {
                    SicmGateSocketThread.dealSystemParameters(devInfo, data);
                    break;
                }
                case "45": {
                    SicmGateSocketThread.dealZoneSencitivity(devInfo, data);
                    break;
                }
                case "88": {
                    logger.info((Object)">>>\u8bbe\u5907\u8fd4\u56de\u7684\u547d\u4ee4\u7c7b\u578b\u4e3a\u83b7\u53d6\u7248\u672c<<<");
                    SicmGateSocketThread.dealModelVersion(devInfo, data);
                    break;
                }
                case "99": {
                    System.out.println(">>>\u8bbe\u5907\u8fd4\u56de\u7684\u547d\u4ee4\u7c7b\u578b\u4e3a\u83b7\u53d6\u8bbe\u5907\u65f6\u95f4<<<");
                    break;
                }
                case "AA": {
                    logger.info((Object)">>>\u8bbe\u5907\u8fd4\u56de\u7684\u547d\u4ee4\u7c7b\u578b\u4e3a\u5fc3\u8df3\u5305<<<");
                    SicmGateSocketThread.dealHeartbeat(devInfo, data);
                    break;
                }
                case "55": {
                    logger.info((Object)(">>>\u8bbe\u5907\u8fd4\u56de\u7684\u8bbe\u7f6e\u53c2\u6570\u7684\u7ed3\u679c<<<" + Arrays.toString(data)));
                    break;
                }
                case "66": {
                    logger.info((Object)(">>>\u8bbe\u5907\u8fd4\u56de\u7684\u7cfb\u7edf\u65f6\u95f4\u6821\u51c6\u7684\u7ed3\u679c<<<" + Arrays.toString(data)));
                    break;
                }
                case "77": {
                    logger.info((Object)(">>>\u8bbe\u5907\u8fd4\u56de\u7684\u7cfb\u7edf\u5bc6\u7801\u4fee\u6539\u7684\u7ed3\u679c<<<" + Arrays.toString(data)));
                }
            }
        }
    }

    public static void dealDevId(SicmGateDeviceInfo devInfo, byte[] data) {
        try {
            byte[] idData = SicmGateSocketThread.subBytes(data, 1, 3);
            String deviceID = SicmGateSocketThread.bytesToDevData(idData);
            JSONObject content = new JSONObject();
            content.put("func", (Object)"gate.id");
            JSONObject jsonData = new JSONObject();
            jsonData.put("device_ip", (Object)devInfo.getDevIp());
            jsonData.put("device_id", (Object)deviceID.toUpperCase());
            content.put("data", (Object)jsonData);
            new SicmGateDevDataRouter().queryRTLog(devInfo, content);
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
    }

    public static void dealWorkParameters(SicmGateDeviceInfo devInfo, byte[] data) {
        try {
            JSONObject jsonData = SicmGateSocketThread.workParametersGroupData(data);
            JSONObject content = new JSONObject();
            content.put("func", (Object)"work.param");
            content.put("data", (Object)jsonData);
            new SicmGateDevDataRouter().sendRTLog(devInfo, content);
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
    }

    public static void dealAlarmLight(SicmGateDeviceInfo devInfo, byte[] data) {
        try {
            byte[] alarmLightByte = SicmGateSocketThread.subBytes(data, 7, 16);
            JSONObject jsonData = SicmGateSocketThread.ledGroupData(alarmLightByte);
            JSONObject content = new JSONObject();
            content.put("func", (Object)"alarm.light");
            content.put("data", (Object)jsonData);
            new SicmGateDevDataRouter().sendRTLog(devInfo, content);
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
    }

    public static void dealSystemParameters(SicmGateDeviceInfo devInfo, byte[] data) {
        try {
            byte[] systemParamByte = SicmGateSocketThread.subBytes(data, 7, 15);
            System.out.println(">>>\u83b7\u53d6\u5230\u7684\u7cfb\u7edf\u53c2\u6570\u6570\u636e\u4e3a: <<<" + SicmGateSocketThread.bytesToHexString(data));
            JSONObject jsonData = SicmGateSocketThread.systemParamGroupData(systemParamByte);
            JSONObject content = new JSONObject();
            content.put("func", (Object)"system.param");
            content.put("data", (Object)jsonData);
            new SicmGateDevDataRouter().queryRTLog(devInfo, content);
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
    }

    public static void dealZoneSencitivity(SicmGateDeviceInfo devInfo, byte[] data) {
        try {
            byte[] zoneSencitivityByte = SicmGateSocketThread.subBytes(data, 7, 24);
            System.out.println(">>>\u83b7\u53d6\u5230\u7684\u533a\u57df\u53c2\u6570\u6570\u636e\u4e3a: <<<" + SicmGateSocketThread.bytesToHexString(data));
            JSONObject jsonData = SicmGateSocketThread.zoneSencitivityGroupData(zoneSencitivityByte);
            JSONObject content = new JSONObject();
            content.put("func", (Object)"zone.sencitivity");
            content.put("data", (Object)jsonData);
            new SicmGateDevDataRouter().queryRTLog(devInfo, content);
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
    }

    private static String bytesToDevData(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(0xFF & data[i] - 51);
            if (hex.length() < 2) {
                buffer.append(0);
            }
            buffer.append(hex);
        }
        return buffer.toString();
    }

    private static JSONObject workParametersGroupData(byte[] data) {
        JSONObject jsonData = new JSONObject();
        try {
            byte[] personCountByte = SicmGateSocketThread.subBytes(data, 7, 5);
            byte[] alarmTimesByte = SicmGateSocketThread.subBytes(data, 12, 5);
            byte[] alarmTimeByte = SicmGateSocketThread.subBytes(data, 17, 5);
            int zoneCount = data[22] - 51;
            int workChannel = data[23] - 51 & 0xFF;
            jsonData.put("person_count", (Object)SicmGateSocketThread.cmdDealByte(personCountByte));
            jsonData.put("alarm_times", (Object)SicmGateSocketThread.cmdDealByte(alarmTimesByte));
            jsonData.put("alarm_time", (Object)SicmGateSocketThread.cmdDealByteOfAlarmTime(alarmTimeByte));
            jsonData.put("zone_count", (Object)zoneCount);
            jsonData.put("work_channel", (Object)workChannel);
            System.out.println(">>>person_count:<<<" + SicmGateSocketThread.cmdDealByte(personCountByte) + ">>>alarm_times:<<<" + SicmGateSocketThread.cmdDealByte(alarmTimesByte) + ">>>alarm_time:<<<" + SicmGateSocketThread.cmdDealByteOfAlarmTime(alarmTimeByte) + ">>>zone_count:<<<" + zoneCount + ">>>work_channel:<<<" + workChannel);
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
        return jsonData;
    }

    public static JSONObject ledGroupData(byte[] data) {
        JSONObject jsonData = new JSONObject();
        try {
            for (int i = 0; i < data.length; ++i) {
                String temp = Integer.toBinaryString(0xFF & data[i] - 51);
                if (temp.length() < 8) {
                    while (temp.length() < 8) {
                        temp = "0" + temp;
                    }
                    jsonData.put("led_" + i, (Object)temp);
                    continue;
                }
                jsonData.put("led_" + i, (Object)Integer.toBinaryString(0xFF & data[i] - 51));
            }
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
        return jsonData;
    }

    private static JSONObject systemParamGroupData(byte[] data) {
        JSONObject jsonData = new JSONObject();
        try {
            jsonData.put("sensitivity_level", (Object)(0xFF & data[0] - 51));
            jsonData.put("df_sensitivity", (Object)(0xFF & data[1] - 51));
            jsonData.put("alarm_sound_duration", (Object)(0xFF & data[2] - 51));
            jsonData.put("alarm_led_duration", (Object)(0xFF & data[3] - 51));
            jsonData.put("alarm_volume", (Object)(0xFF & data[4] - 51));
            jsonData.put("alarm_tone", (Object)(0xFF & data[5] - 51));
            jsonData.put("defence_zone", (Object)(0xFF & data[6] - 51));
            jsonData.put("language", (Object)(0xFF & data[7] - 51));
            jsonData.put("power_on", (Object)(0xFF & data[8] - 51));
            jsonData.put("work_channel", (Object)(0xFF & data[9] - 51));
            jsonData.put("detection_speed", (Object)(0xFF & data[10] - 51));
            jsonData.put("dispaly_mode", (Object)(0xFF & data[11] - 51));
            jsonData.put("led_brightness", (Object)(0xFF & data[12] - 51));
            byte[] overallSencitivityByte = SicmGateSocketThread.subBytes(data, 13, 2);
            jsonData.put("overall_sencitivity", (Object)SicmGateSocketThread.bytesToIntOfHighFirst(overallSencitivityByte));
            logger.info((Object)jsonData.toString());
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
        return jsonData;
    }

    private static JSONObject zoneSencitivityGroupData(byte[] data) {
        JSONObject jsonData = new JSONObject();
        try {
            for (int i = 0; i < data.length; ++i) {
                if (i % 2 != 0) continue;
                jsonData.put("zone_sencitivity_" + (i / 2 + 1), (Object)SicmGateSocketThread.bytesToIntOfHighFirst(SicmGateSocketThread.subBytes(data, i, 2)));
            }
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
        return jsonData;
    }

    private static int bytesToIntOfHighFirst(byte[] data) {
        int result = 0;
        if (data.length == 2) {
            int a = (0xFF & data[0] - 51) << 8;
            int b = 0xFF & data[1] - 51;
            result = a | b;
        }
        return result;
    }

    private static String cmdDealByte(byte[] data) {
        String buffer = new String();
        for (int i = 0; i < data.length; ++i) {
            String temp = Integer.toHexString(0xFF & data[i] - 51);
            buffer = buffer + temp;
        }
        return buffer;
    }

    private static String cmdDealByteOfAlarmTime(byte[] data) {
        String buffer = new String();
        for (int i = 0; i < data.length; ++i) {
            String temp = Integer.toHexString(0xFF & data[i] - 51);
            Integer time = Integer.parseInt(temp, 16);
            if ((temp = time.toString()).length() < 2) {
                temp = "0" + temp;
            }
            buffer = buffer + temp;
        }
        return buffer;
    }

    public static byte[] subBytes(byte[] src, int begin, int count) {
        byte[] bs = new byte[count];
        System.arraycopy(src, begin, bs, 0, count);
        return bs;
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public void addDevToThread(SicmGateDeviceInfo devInfo) {
        if (!this.devInfoList.contains(devInfo)) {
            devInfo.monitorThread = this;
            this.devInfoList.add(devInfo);
        }
    }

    private Boolean checkCS(byte[] data) {
        int len = data[5] - 51;
        byte cs = 0;
        for (int i = 0; i < len + 6; ++i) {
            cs = (byte)(cs + data[i]);
        }
        return data[len + 6] == cs;
    }

    public static void dealModelVersion(SicmGateDeviceInfo devInfo, byte[] data) {
        try {
            logger.info((Object)"dealModelVersion in");
            byte[] idData = SicmGateSocketThread.subBytes(data, 1, 3);
            byte[] verSionData = SicmGateSocketThread.subBytes(data, 7, 11);
            String deviceID = SicmGateSocketThread.bytesToDevData(idData);
            String deviceVersion = SicmGateSocketThread.cmdDealByteOfModelVersion(verSionData);
            JSONObject content = new JSONObject();
            content.put("func", (Object)"gate.model");
            JSONObject jsonData = new JSONObject();
            jsonData.put("device_id", (Object)deviceID.toUpperCase());
            jsonData.put("device_model", (Object)deviceVersion);
            content.put("data", (Object)jsonData);
            logger.info((Object)("dealModelVersion out,device_id:" + deviceID + ",device_model:" + deviceVersion));
            new SicmGateDevDataRouter().queryRTLog(devInfo, content);
        }
        catch (Exception e) {
            logger.error((Object)"exception", (Throwable)e);
        }
    }

    private static String cmdDealByteOfModelVersion(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            String temp = Integer.toHexString(0xFF & data[i] - 51);
            int code = Integer.parseInt(temp, 16);
            sb.append((char)code);
        }
        String buffer = sb.toString();
        return buffer;
    }

    public static void dealHeartbeat(SicmGateDeviceInfo devInfo, byte[] data) {
        JSONObject content = new JSONObject();
        content.put("func", (Object)"gate.heartbeat");
        String jsonData = SicmGateSocketThread.bytesToHexString(data);
        content.put("data", (Object)jsonData);
        logger.info((Object)("dealHeartbeat out,data:" + jsonData));
        new SicmGateDevDataRouter().queryRTLog(devInfo, content);
    }

    public Map<String, Socket> getSocketMap() {
        return this.socketMap;
    }

    public void setSocketMap(Map<String, Socket> socketMap) {
        this.socketMap = socketMap;
    }

    public List<SicmGateDeviceInfo> getDevInfoList() {
        return this.devInfoList;
    }

    public void setDevInfoList(List<SicmGateDeviceInfo> devInfoList) {
        this.devInfoList = devInfoList;
    }
}

