/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.api.controller;

import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/door"})
public class AccCloudApiDoorController {
    private static final Logger log = LoggerFactory.getLogger(AccCloudApiDoorController.class);
    @Autowired
    private AccDoorService accDoorService;

    @ResponseBody
    @ApiPermissions(moduleCode="acc", moduleName="acc_module")
    @RequestMapping(value={"/operateDoorByApp"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Operate Door By App", notes="Operate Door By App", response=ApiResultMessage.class)
    public ZKResultMsg operateDoorByApp(@RequestBody ZKMessage message) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        Map map = message.getContent();
        String messageId = message.getMessageId();
        String openInterval = MapUtils.getString((Map)map, (Object)"openInterval");
        String operator = MapUtils.getString((Map)map, (Object)"operator");
        boolean isAdmin = MapUtils.getBoolean((Map)map, (Object)"isAdmin", (Boolean)false);
        Map doorMap = (Map)map.get("doors");
        if (doorMap != null && !doorMap.isEmpty()) {
            for (String sn : doorMap.keySet()) {
                String doorNos;
                List doorNoList;
                String doorIds;
                if (doorMap.get(sn) == null || ((List)doorMap.get(sn)).isEmpty() || !StringUtils.isNotBlank((CharSequence)(doorIds = this.accDoorService.getDoorByDevSnAndDoorNos(sn, doorNoList = Arrays.stream((doorNos = StringUtils.join((Iterable)((Iterable)doorMap.get(sn)), (String)",")).split(",")).map(s -> Short.parseShort(s.trim())).collect(Collectors.toList()))))) continue;
                String opType = messageId.split("#", 2)[1];
                if ("cloudOpenDoor".equals(opType)) {
                    opType = "openDoor";
                } else if ("cloudCancelAlarm".equals(opType)) {
                    opType = "cancelAlarm";
                }
                resultMsg = this.accDoorService.operateDoor(opType, openInterval, doorIds, operator, isAdmin);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @ResponseBody
    @ApiPermissions(moduleCode="acc", moduleName="acc_module")
    @RequestMapping(value={"/topDoor"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Top Door By App", notes="Top Door By App", response=ApiResultMessage.class)
    public ZKResultMsg topDoor(@RequestBody ZKMessage message) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        Map map = message.getContent();
        String operator = (String)map.get("operator");
        Map devDoorMap = (Map)map.get("devDoorMap");
        if (devDoorMap != null && !devDoorMap.isEmpty()) {
            for (String sn : devDoorMap.keySet()) {
                String doorNos;
                List doorNoList;
                String doorId;
                if (devDoorMap.get(sn) == null || !StringUtils.isNotBlank((CharSequence)(doorId = this.accDoorService.getDoorByDevSnAndDoorNos(sn, doorNoList = Arrays.stream((doorNos = StringUtils.join((Object[])new Serializable[]{(Serializable)devDoorMap.get(sn), ","})).split(",")).map(s -> Short.parseShort(s.trim())).collect(Collectors.toList()))))) continue;
                resultMsg = this.accDoorService.topDoor(operator, doorId);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @ResponseBody
    @ApiPermissions(moduleCode="acc", moduleName="acc_module")
    @RequestMapping(value={"/cancleTopDoor"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Cancle Top Door By App", notes="Cancle Top Door By App", response=ApiResultMessage.class)
    public ZKResultMsg cancleTopDoor(@RequestBody ZKMessage message) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        Map map = message.getContent();
        String operator = (String)map.get("operator");
        Map devDoorMap = (Map)map.get("devDoorMap");
        if (devDoorMap != null && !devDoorMap.isEmpty()) {
            for (String sn : devDoorMap.keySet()) {
                String doorNos;
                List doorNoList;
                String doorId;
                if (devDoorMap.get(sn) == null || !StringUtils.isNotBlank((CharSequence)(doorId = this.accDoorService.getDoorByDevSnAndDoorNos(sn, doorNoList = Arrays.stream((doorNos = StringUtils.join((Object[])new Serializable[]{(Serializable)devDoorMap.get(sn), ","})).split(",")).map(s -> Short.parseShort(s.trim())).collect(Collectors.toList()))))) continue;
                resultMsg = this.accDoorService.cancleTopDoor(operator, doorId);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

