/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccGlobalInterlockDoorRemote;
import com.zkteco.zkbiosecurity.acc.service.AccGlobalInterlockDoorService;
import com.zkteco.zkbiosecurity.acc.vo.AccGlobalInterlockDoorItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccGlobalInterlockDoorController
extends BaseController
implements AccGlobalInterlockDoorRemote {
    @Autowired
    private AccGlobalInterlockDoorService accGlobalInterlockDoorService;

    @RequiresPermissions(value={"acc:globalInterlockDoor"})
    public ModelAndView index() {
        return new ModelAndView("acc/globalInterlockDoor/accGlobalInterlockDoor");
    }

    @RequiresPermissions(value={"acc:globalInterlockDoor:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accGlobalInterlockDoorService.getItemById(id));
        }
        return new ModelAndView("acc/globalInterlockDoor/editAccGlobalInterlockDoor");
    }

    @RequiresPermissions(value={"acc:globalInterlockDoor:edit"})
    @LogRequest(module="acc_module", object="acc_leftMeue_globalInterlockGroup", opType="acc_globalInterlockDoor_edit", requestParams={"id"}, opContent="acc_globalInterlockDoor_id")
    public ZKResultMsg save(AccGlobalInterlockDoorItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accGlobalInterlockDoorService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:globalInterlockGroup:refresh"})
    public DxGrid list(AccGlobalInterlockDoorItem codition) {
        Pager pager = this.accGlobalInterlockDoorService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:globalInterlockGroup:delDoor"})
    @LogRequest(module="acc_module", object="acc_leftMeue_globalInterlockGroup", opType="acc_level_doorDelete", requestParams={"groupName", "doorNames"}, opContent="acc_door_name")
    public ZKResultMsg delDoor(String groupId, String ids) {
        this.accGlobalInterlockDoorService.deleteByIds(ids);
        Long doorCount = this.accGlobalInterlockDoorService.getDoorCount(groupId);
        doorCount = doorCount == null ? Long.valueOf(0L) : doorCount;
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)doorCount));
    }
}

