/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.security;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

public class CustomRedisSerializer
implements RedisSerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(CustomRedisSerializer.class);
    private final Converter<Object, byte[]> serializer;
    private final Converter<byte[], Object> deserializer;
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public CustomRedisSerializer() {
        this((Converter<Object, byte[]>)new SerializingConverter(), (Converter<byte[], Object>)new DeserializingConverter());
    }

    public CustomRedisSerializer(ClassLoader classLoader) {
        this((Converter<Object, byte[]>)new SerializingConverter(), (Converter<byte[], Object>)new DeserializingConverter(classLoader));
    }

    public CustomRedisSerializer(Converter<Object, byte[]> serializer, Converter<byte[], Object> deserializer) {
        Assert.notNull(serializer, (String)"Serializer must not be null!");
        Assert.notNull(deserializer, (String)"Deserializer must not be null!");
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        String str = new String(bytes, DEFAULT_CHARSET);
        return JSON.parseObject((String)str, Object.class);
    }

    public byte[] serialize(Object object) {
        if (object == null) {
            return new byte[0];
        }
        return JSON.toJSONStringWithDateFormat((Object)object, (String)"yyyy-MM-dd hh:MM:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}).getBytes(DEFAULT_CHARSET);
    }
}

