/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.service.AuthCompanyService;
import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.auth.vo.AuthCompanyItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/portal"})
public class RegisterController
extends BaseController {
    @Autowired
    private AuthCompanyService authCompanyService;
    @Autowired
    private AuthUserService authUserService;

    @RequestMapping(value={"/company/register"})
    @ResponseBody
    @LogRequest(module="system_module", object="auth_company", opType="auth_company_register", requestParams={"companyName"}, opContent="auth_company_register")
    public ZKResultMsg register(AuthCompanyItem item) {
        if (StringUtils.isEmpty((CharSequence)item.getAdminName())) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"auth_login_userNotNull", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)item.getEmail())) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"auth_user_emailNotNull", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)item.getTelephone())) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"auth_user_phoneNotNull", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)item.getAdminPwd())) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"auth_user_pwdNotNull", (Object[])new Object[0]));
        }
        if (this.authUserService.isExistUserName(item.getAdminName()).booleanValue()) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"auth_user_usernameExist", (Object[])new Object[0]));
        }
        if (this.authUserService.isExistEmail(item.getEmail())) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"auth_license_serverError2", (Object[])new Object[0]));
        }
        if (this.authUserService.isExistPhone(item.getTelephone())) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"auth_user_phoneExist", (Object[])new Object[0]));
        }
        item.setStatus("1");
        item = this.authCompanyService.register(item);
        ZKResultMsg ret = new ZKResultMsg();
        ret.setData((Object)item);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }
}

