/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.zkteco.zkbiosecurity.auth.remote.AuthAreaRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthAreaService;
import com.zkteco.zkbiosecurity.auth.util.AuthExportTemplateUtil;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.Tree;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthAreaController
extends ExportController
implements AuthAreaRemote {
    @Autowired
    private AuthAreaService authAreaService;
    @Autowired
    private AuthExportTemplateUtil authExportTemplateUtil;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"auth:area"})
    public ModelAndView index() {
        return new ModelAndView("auth/area/authArea");
    }

    @RequiresPermissions(value={"auth:area:add", "auth:area:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.authAreaService.getItemById(id));
        }
        return new ModelAndView("auth/area/editAuthArea");
    }

    @LogRequest(module="system_module", object="base_leftMenu_locale", opType="base_area_editArea", requestParams={"name"}, opContent="base_area_name")
    @RequiresPermissions(value={"auth:area:add", "auth:area:edit"})
    public ZKResultMsg save(AuthAreaItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.authAreaService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"auth:area:refresh"})
    public DxGrid list(AuthAreaItem codition) {
        Pager pager = this.authAreaService.loadPagerByAuthAreaFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="system_module", object="base_leftMenu_locale", opType="base_area_delArea", requestParams={"names"}, opContent="base_area_name")
    @RequiresPermissions(value={"auth:area:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.authAreaService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public TreeItem tree() {
        List authAreaItems = this.authAreaService.loadPagerByAuthFilter(this.request.getSession().getId(), new AuthAreaItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (AuthAreaItem depart : authAreaItems) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getName());
            pItem = depart.getParentId() != null ? new TreeItem(depart.getParentId()) : new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public String valid(String code) {
        AuthAreaItem item = this.authAreaService.getItemByCode(code);
        boolean rs = item == null;
        return rs + "";
    }

    public String validName(String name) {
        AuthAreaItem item = this.authAreaService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg isItself(String id, String parentId) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.authAreaService.isItself(id, parentId)));
    }

    public Tree dynaTree(String id, Boolean showPersonCount) {
        AuthAreaItem condition = new AuthAreaItem();
        if (!this.isQueryTopArea(id)) {
            condition.setParentId(id);
        }
        List<AuthAreaItem> authAreaItems = this.authAreaService.loadPagerByAuthFilter(this.request.getSession().getId(), condition);
        Set isHasChild = null;
        if (this.isQueryTopArea(id) && !CollectionUtils.isEmpty((Collection)authAreaItems)) {
            authAreaItems = this.getTopAndTwoArea(authAreaItems);
            isHasChild = authAreaItems.stream().map(AuthAreaItem::getParentId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        }
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (AuthAreaItem authAreaItem : authAreaItems) {
            item = new TreeItem();
            item.setId(authAreaItem.getId());
            item.setText(authAreaItem.getName());
            item.setChild("1");
            if (this.isQueryTopArea(id) && Objects.isNull(authAreaItem.getParentId())) {
                if (Objects.nonNull(isHasChild) && isHasChild.contains(authAreaItem.getId())) {
                    item.setOpen("1");
                } else {
                    item.setOpen(null);
                    item.setChild(null);
                }
            } else {
                item.setOpen(null);
            }
            pItem = authAreaItem.getParentId() != null ? new TreeItem(authAreaItem.getParentId()) : new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        Tree tree = new Tree(treeItems);
        tree.setId(StringUtils.isBlank((CharSequence)id) ? "0" : id);
        return tree;
    }

    private boolean isQueryTopArea(String id) {
        return StringUtils.isBlank((CharSequence)id) || "0".equals(id);
    }

    private List<AuthAreaItem> getTopAndTwoArea(List<AuthAreaItem> areaItems) {
        Map authAreaMap = areaItems.stream().collect(Collectors.toMap(AuthAreaItem::getId, Function.identity()));
        List<AuthAreaItem> topAndTwo = areaItems.stream().filter(item -> Objects.isNull(item.getParentId()) || !authAreaMap.containsKey(item.getParentId())).collect(Collectors.toList());
        Map topMap = topAndTwo.stream().collect(Collectors.toMap(AuthAreaItem::getId, Function.identity()));
        List twoList = areaItems.stream().filter(item -> Objects.nonNull(item.getParentId()) && topMap.containsKey(item.getParentId())).collect(Collectors.toList());
        topAndTwo.addAll(twoList);
        return topAndTwo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), AuthAreaItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg res = this.authAreaService.importData(itemList);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)res);
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    public void export(HttpServletRequest request, HttpServletResponse response) {
        String exportType = request.getParameter("exportType");
        String recordStart = request.getParameter("recordstart");
        String recordCount = request.getParameter("recordcount");
        int beginIndex = 0;
        int endIndex = 30000;
        if (exportType.equals("3") && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : 0;
            int maxCount = Integer.valueOf(recordCount) > 30000 ? 30000 : Integer.valueOf(recordCount);
            endIndex = beginIndex + maxCount - 1;
        }
        AuthAreaItem authAreaItem = new AuthAreaItem();
        this.setConditionValue((BaseItem)authAreaItem);
        List list = this.authAreaService.getItemData(request.getSession().getId(), AuthAreaItem.class, authAreaItem, beginIndex, endIndex);
        this.excelExport(list, AuthAreaItem.class);
    }

    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = JSONObject.parseObject((String)request.getParameter("jsonColumn"), (Feature[])new Feature[]{Feature.OrderedField});
        HashMap<String, String> commentMap = new HashMap<String, String>();
        Iterator iterator = jsonObject.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "code": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                    break;
                }
                case "name": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                    break;
                }
                case "parentCode": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                }
            }
        }
        this.authExportTemplateUtil.templateExport(request, response, commentMap);
    }
}

