/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.config;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnMissingBean(value={MessageSource.class}, search=SearchStrategy.CURRENT)
@AutoConfigureOrder(value=-2147483648)
@Conditional(value={ResourceBundleCondition.class})
@EnableConfigurationProperties
@ConfigurationProperties(prefix="spring.defined.messages")
public class MessageSourceAutoConfiguration {
    public static Resource[] RESOURCES = new Resource[0];
    private String basename = "messages";
    private Charset encoding = Charset.forName("UTF-8");
    private int cacheSeconds = -1;
    private boolean fallbackToSystemLocale = true;
    private boolean alwaysUseMessageFormat = false;
    private boolean useCodeAsDefaultMessage = true;

    public static Resource[] loadResources(String locationPattern) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources("classpath*:" + locationPattern);
            return resources;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    public MessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        Resource[] systemResources = MessageSourceAutoConfiguration.loadResources(this.basename);
        String basename1 = "";
        ArrayList<String> tempList = new ArrayList<String>();
        for (Resource resource : systemResources) {
            System.out.println(resource.getFilename());
            String prifix = resource.getFilename().split("_")[0];
            if (tempList.contains(prifix)) continue;
            basename1 = basename1 + "local/" + prifix + ",";
            tempList.add(prifix);
        }
        if (StringUtils.hasText((String)basename1)) {
            this.basename = basename1.substring(0, basename1.length() - 1);
        }
        if (StringUtils.hasText((String)this.basename)) {
            messageSource.setBasenames(StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)this.basename)));
        }
        if (this.encoding != null) {
            messageSource.setDefaultEncoding(this.encoding.name());
        }
        messageSource.setFallbackToSystemLocale(this.fallbackToSystemLocale);
        messageSource.setCacheSeconds(this.cacheSeconds);
        messageSource.setAlwaysUseMessageFormat(this.alwaysUseMessageFormat);
        messageSource.setUseCodeAsDefaultMessage(this.useCodeAsDefaultMessage);
        RESOURCES = systemResources;
        return messageSource;
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public int getCacheSeconds() {
        return this.cacheSeconds;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }

    public boolean isFallbackToSystemLocale() {
        return this.fallbackToSystemLocale;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    public boolean isAlwaysUseMessageFormat() {
        return this.alwaysUseMessageFormat;
    }

    public void setAlwaysUseMessageFormat(boolean alwaysUseMessageFormat) {
        this.alwaysUseMessageFormat = alwaysUseMessageFormat;
    }

    public boolean isUseCodeAsDefaultMessage() {
        return this.useCodeAsDefaultMessage;
    }

    public void setUseCodeAsDefaultMessage(boolean useCodeAsDefaultMessage) {
        this.useCodeAsDefaultMessage = useCodeAsDefaultMessage;
    }

    protected static class ResourceBundleCondition
    extends SpringBootCondition {
        private static ConcurrentReferenceHashMap<String, ConditionOutcome> cache = new ConcurrentReferenceHashMap();

        protected ResourceBundleCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionOutcome outcome;
            String basename = context.getEnvironment().getProperty("spring.defined.messages.basename", "messages");
            Resource[] systemResources = MessageSourceAutoConfiguration.loadResources(basename);
            String basename1 = "";
            ArrayList<String> tempList = new ArrayList<String>();
            for (Resource resource : systemResources) {
                String prifix = resource.getFilename().split("_")[0];
                if (tempList.contains(prifix)) continue;
                basename1 = basename1 + "local/" + prifix + ",";
                tempList.add(prifix);
            }
            if (StringUtils.hasText((String)basename1)) {
                basename = basename1.substring(0, basename1.length() - 1);
            }
            if ((outcome = (ConditionOutcome)cache.get((Object)basename)) == null) {
                outcome = this.getMatchOutcomeForBasename(context, basename);
                cache.put((Object)basename, (Object)outcome);
            }
            return outcome;
        }

        private ConditionOutcome getMatchOutcomeForBasename(ConditionContext context, String basename) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"ResourceBundle", (Object[])new Object[0]);
            for (String name : StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)basename))) {
                for (Resource resource : this.getResources(context.getClassLoader(), name)) {
                    if (!resource.exists()) continue;
                    return ConditionOutcome.match((ConditionMessage)message.found("bundle").items(new Object[]{resource}));
                }
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("bundle with basename " + basename).atAll());
        }

        private Resource[] getResources(ClassLoader classLoader, String name) {
            try {
                return new PathMatchingResourcePatternResolver(classLoader).getResources("classpath*:" + name + "*.properties");
            }
            catch (Exception ex) {
                return RESOURCES;
            }
        }
    }
}

