/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosHandConsumeRemote;
import com.zkteco.zkbiosecurity.pos.service.PosHandConsumeService;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.pos.vo.PosHandConsumeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosHandConsumeController
extends BaseController
implements PosHandConsumeRemote {
    @Autowired
    private PosHandConsumeService posHandConsumeService;
    @Autowired
    private PosSystemParamService posSystemParamService;

    @RequiresPermissions(value={"pos:handConsume"})
    public ModelAndView index() {
        return new ModelAndView("pos/handConsume/posHandConsume");
    }

    @RequiresPermissions(value={"pos:handConsume:edit"})
    public ModelAndView edit(String id) {
        this.request.setAttribute("cardModel", (Object)this.posSystemParamService.getDoubleCash());
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posHandConsumeService.getItemById(id));
        }
        return new ModelAndView("pos/handConsume/editPosHandConsume");
    }

    @RequiresPermissions(value={"pos:handConsume:edit"})
    @LogRequest(module="pos_module", object="pos_leftMenu_handConsume", opType="common_op_new", requestParams={"personPin"}, opContent="pos_card_personNum")
    public ZKResultMsg save(PosHandConsumeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posHandConsumeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:handConsume:refresh"})
    public DxGrid list(PosHandConsumeItem codition) {
        Pager pager = this.posHandConsumeService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pos:handConsume:del"})
    @LogRequest(module="pos_module", object="pos_leftMenu_handConsume", opType="common_op_del", requestParams={"ids"}, opContent="pos_common_id")
    public ZKResultMsg delete(String ids) {
        this.posHandConsumeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkHandConsume() {
        String date = this.request.getParameter("dateTime");
        String cardId = this.request.getParameter("cardId");
        Double balance = Double.parseDouble(this.request.getParameter("Banlance"));
        String needMoney = this.request.getParameter("money");
        String posMoneySub = this.request.getParameter("PosMoney_Sub") == null ? "0" : this.request.getParameter("PosMoney_Sub");
        Double subBalance = Double.parseDouble(posMoneySub);
        String batchNo = this.request.getParameter("SubsidyBatch");
        ZKResultMsg ret = this.posHandConsumeService.checkHandConsume(date, cardId, balance, needMoney, subBalance, batchNo);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    @LogRequest(module="pos_module", object="pos_leftMenu_handConsume", opType="common_op_new", requestParams={"personPin"}, opContent="pos_card_personNum")
    public ZKResultMsg editHandConsume() {
        String deviceId = this.request.getParameter("posDeviceId");
        Double needMoney = Double.parseDouble(this.request.getParameter("money"));
        String date = this.request.getParameter("dateTime");
        String cardSerial = this.request.getParameter("CardMark");
        String sysCardNo = this.request.getParameter("SysID");
        Double finalBlance = Double.parseDouble(this.request.getParameter("Banlance"));
        String subBalance = this.request.getParameter("PosMoney_Sub");
        String mealId = this.request.getParameter("mealId");
        Double cashMoney = Double.parseDouble(StringUtils.isNotBlank((CharSequence)this.request.getParameter("cashMoney")) ? this.request.getParameter("cashMoney") : "0.0");
        Double allowMoney = Double.parseDouble(StringUtils.isNotBlank((CharSequence)this.request.getParameter("allowMoney")) ? this.request.getParameter("allowMoney") : "0.0");
        return this.posHandConsumeService.editHandConsume(mealId, date, deviceId, sysCardNo, cardSerial, needMoney, finalBlance, subBalance, cashMoney, allowMoney);
    }
}

