/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.client.utils.ParkClientCommonUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.park.service.ParkPersonService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.vo.ParkPersonItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordoutItem;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkRecordoutHandle {
    private static final Logger log = LoggerFactory.getLogger(ParkRecordoutHandle.class);
    @Autowired
    private ParkPersonService parkPersonService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;

    public ZKResultMsg getItemsByPage(ZKMessage msg) {
        log.info("PARK_CLOUD ParkRecordoutHandle getItemsByPage msg = {}", (Object)msg);
        Map retMap = msg.getContent();
        int page = ParkClientCommonUtil.getIntValue(retMap, "page");
        int size = ParkClientCommonUtil.getIntValue(retMap, "size");
        JSONObject json = (JSONObject)retMap.get("parkCloudRecordoutItem");
        ParkRecordoutItem parkRecordoutItem = (ParkRecordoutItem)JSONObject.toJavaObject((JSON)json, ParkRecordoutItem.class);
        Pager pager = this.parkRecordoutService.getItemsByPage((BaseItem)parkRecordoutItem, page, size);
        return new ZKResultMsg((Object)pager);
    }

    public ZKResultMsg getItemsByPin(ZKMessage msg) {
        log.info("PARK_CLOUD ParkRecordoutHandle getItemsByPage msg = {}", (Object)msg);
        Map retMap = msg.getContent();
        String pin = ParkClientCommonUtil.getStringValue(retMap, "pin");
        int page = ParkClientCommonUtil.getIntValue(retMap, "page");
        int size = ParkClientCommonUtil.getIntValue(retMap, "size");
        JSONObject json = (JSONObject)retMap.get("parkCloudRecordoutItem");
        ParkRecordoutItem parkRecordoutItem = (ParkRecordoutItem)JSONObject.toJavaObject((JSON)json, ParkRecordoutItem.class);
        if (StringUtils.isNotBlank((CharSequence)pin)) {
            ParkPersonItem parkPersonItem = this.parkPersonService.getByPin(pin);
            if (parkPersonItem != null) {
                parkRecordoutItem.setUserName(parkPersonItem.getPersPersonName());
            } else {
                return new ZKResultMsg(null);
            }
        }
        Pager pager = this.parkRecordoutService.getItemsByPage((BaseItem)parkRecordoutItem, page, size);
        return new ZKResultMsg((Object)pager);
    }
}

