/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@From(after="SIS_DEVICE t left join AUTH_AREA a on t.AUTH_AREA_ID = a.ID")
@OrderBy(after="t.UPDATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=450, minWidth="140", operates={@GridOperate(type="edit", permission="sisTipPic:device:edit", url="/sisDevice.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="sisTipPic:device:del", url="/sisDevice.do?del&sn=(sn)", label="common_op_del")})
public class SisDeviceItem
extends BaseItem
implements Serializable {
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sortNo=0, sort="na")
    private String id;
    @Column(name="t.SN")
    @GridColumn(columnType="edit", label="common_dev_sn", width="140", sortNo=1, editPermission="sisTipPic:device:edit", editUrl="/sisDevice.do?edit")
    private String sn;
    @Column(name="t.NAME")
    @GridColumn(label="common_dev_name", width="90")
    private String name;
    @Column(name="t.MODEL")
    @GridColumn(label="sis_device_model", width="90")
    private String model;
    @Column(name="t.IP")
    @GridColumn(label="common_ipAddress", width="100")
    private String ip;
    @Column(name="STATE")
    @GridColumn(label="sis_device_state", width="90", columnType="custom", convert="convertToIcon")
    private Boolean state;
    @GridColumn(label="sis_device_onlineStatus", width="90", columnType="custom", convert="convertConnectState", sort="na")
    private Boolean onlineStatus;
    @Column(name="t.NVR_SN")
    @GridColumn(label="sis_device_nvrSn", width="90", show=false)
    private String nvrSn;
    @Column(name="t.MASK")
    @GridColumn(label="sis_device_mask", width="90", show=false)
    private String mask;
    @Column(name="t.GATE")
    @GridColumn(label="sis_device_gate", width="90", show=false)
    private String gate;
    @Column(name="t.VERSION_SOFT")
    @GridColumn(label="sis_device_versionSoft", width="90")
    private String versionSoft;
    @Column(name="t.VERSION_PUSH")
    @GridColumn(label="sis_device_versionPush", width="90")
    private String versionPush;
    @Column(name="t.PORT")
    private Integer port;
    @Column(name="t.DEVICE_STATE")
    private Integer deviceState;
    @Column(name="t.AUTH_AREA_ID", equalTag="in")
    private String authAreaId;
    @Column(name="a.NAME")
    @GridColumn(label="base_area_name", width="90")
    private String authAreaName;
    @Condition(value="t.AUTH_AREA_ID IN (%s)", formatType="quote")
    private String areaIdIn;
    @Condition(value="t.MODEL", equalTag="in")
    private String inModel;
    @Condition(value="t.TYPE", equalTag="in")
    private String inType;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Column(name="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.UPDATE_TIME", equalTag=">")
    private Date lastUpdateDate;
    @Condition(value="t.CREATE_TIME")
    private Date createTime;
    @Column(name="t.TYPE")
    private String type;

    public SisDeviceItem() {
    }

    public SisDeviceItem(Boolean equals) {
        super(equals);
    }

    public SisDeviceItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SisDeviceItem item = (SisDeviceItem)o;
        return Objects.equals(this.id, item.id) && Objects.equals(this.sn, item.sn) && Objects.equals(this.name, item.name) && Objects.equals(this.model, item.model) && Objects.equals(this.ip, item.ip) && Objects.equals(this.state, item.state) && Objects.equals(this.onlineStatus, item.onlineStatus) && Objects.equals(this.nvrSn, item.nvrSn) && Objects.equals(this.mask, item.mask) && Objects.equals(this.gate, item.gate) && Objects.equals(this.versionSoft, item.versionSoft) && Objects.equals(this.versionPush, item.versionPush) && Objects.equals(this.port, item.port) && Objects.equals(this.deviceState, item.deviceState) && Objects.equals(this.authAreaId, item.authAreaId) && Objects.equals(this.authAreaName, item.authAreaName) && Objects.equals(this.areaIdIn, item.areaIdIn) && Objects.equals(this.inModel, item.inModel) && Objects.equals(this.inType, item.inType) && Objects.equals(this.notInId, item.notInId) && Objects.equals(this.inId, item.inId) && Objects.equals(this.lastUpdateDate, item.lastUpdateDate) && Objects.equals(this.createTime, item.createTime) && Objects.equals(this.type, item.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.sn, this.name, this.model, this.ip, this.state, this.onlineStatus, this.nvrSn, this.mask, this.gate, this.versionSoft, this.versionPush, this.port, this.deviceState, this.authAreaId, this.authAreaName, this.areaIdIn, this.inModel, this.inType, this.notInId, this.inId, this.lastUpdateDate, this.createTime, this.type);
    }

    public String getId() {
        return this.id;
    }

    public String getSn() {
        return this.sn;
    }

    public String getName() {
        return this.name;
    }

    public String getModel() {
        return this.model;
    }

    public String getIp() {
        return this.ip;
    }

    public Boolean getState() {
        return this.state;
    }

    public Boolean getOnlineStatus() {
        return this.onlineStatus;
    }

    public String getNvrSn() {
        return this.nvrSn;
    }

    public String getMask() {
        return this.mask;
    }

    public String getGate() {
        return this.gate;
    }

    public String getVersionSoft() {
        return this.versionSoft;
    }

    public String getVersionPush() {
        return this.versionPush;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getDeviceState() {
        return this.deviceState;
    }

    public String getAuthAreaId() {
        return this.authAreaId;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getInModel() {
        return this.inModel;
    }

    public String getInType() {
        return this.inType;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getInId() {
        return this.inId;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getType() {
        return this.type;
    }

    public SisDeviceItem setId(String id) {
        this.id = id;
        return this;
    }

    public SisDeviceItem setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public SisDeviceItem setName(String name) {
        this.name = name;
        return this;
    }

    public SisDeviceItem setModel(String model) {
        this.model = model;
        return this;
    }

    public SisDeviceItem setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public SisDeviceItem setState(Boolean state) {
        this.state = state;
        return this;
    }

    public SisDeviceItem setOnlineStatus(Boolean onlineStatus) {
        this.onlineStatus = onlineStatus;
        return this;
    }

    public SisDeviceItem setNvrSn(String nvrSn) {
        this.nvrSn = nvrSn;
        return this;
    }

    public SisDeviceItem setMask(String mask) {
        this.mask = mask;
        return this;
    }

    public SisDeviceItem setGate(String gate) {
        this.gate = gate;
        return this;
    }

    public SisDeviceItem setVersionSoft(String versionSoft) {
        this.versionSoft = versionSoft;
        return this;
    }

    public SisDeviceItem setVersionPush(String versionPush) {
        this.versionPush = versionPush;
        return this;
    }

    public SisDeviceItem setPort(Integer port) {
        this.port = port;
        return this;
    }

    public SisDeviceItem setDeviceState(Integer deviceState) {
        this.deviceState = deviceState;
        return this;
    }

    public SisDeviceItem setAuthAreaId(String authAreaId) {
        this.authAreaId = authAreaId;
        return this;
    }

    public SisDeviceItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public SisDeviceItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public SisDeviceItem setInModel(String inModel) {
        this.inModel = inModel;
        return this;
    }

    public SisDeviceItem setInType(String inType) {
        this.inType = inType;
        return this;
    }

    public SisDeviceItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public SisDeviceItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public SisDeviceItem setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    public SisDeviceItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public SisDeviceItem setType(String type) {
        this.type = type;
        return this;
    }
}

