/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.util.WebUtils;

public class PropertiesUtil {
    public static String getProperty(String name) {
        return SpringContextUtil.getApplicationContext().getEnvironment().getProperty(name);
    }

    private static HttpServletRequest getCurrentRequest() throws IllegalStateException {
        ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attrs == null) {
            return null;
        }
        return attrs.getRequest();
    }

    public static String getCurrentLanguage() {
        Cookie cookie;
        HttpServletRequest request = PropertiesUtil.getCurrentRequest();
        String lang = "";
        if (request != null && StringUtils.isBlank((CharSequence)(lang = request.getParameter("lang"))) && (cookie = WebUtils.getCookie((HttpServletRequest)request, (String)CookieLocaleResolver.LOCALE_REQUEST_ATTRIBUTE_NAME)) != null) {
            lang = cookie.getValue();
        }
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system.language");
        }
        return lang;
    }

    public static boolean enableRTL() {
        String enableRTL = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system.enableRTL");
        if (StringUtils.isNotBlank((CharSequence)enableRTL) && "true".equalsIgnoreCase(enableRTL)) {
            return true;
        }
        String lang = PropertiesUtil.getCurrentLanguage();
        return StringUtils.isNotBlank((CharSequence)lang) && lang.startsWith("ar");
    }
}

