/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.core.utils.FileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class ImgEncodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(ImgEncodeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeBase64(String filePath) {
        InputStream in = null;
        String imgBase64Str = null;
        try {
            File file = new File(filePath);
            if (file.exists()) {
                in = new FileInputStream(file);
                byte[] data = new byte[in.available()];
                in.read(data);
                imgBase64Str = new BASE64Encoder().encode(data);
            }
        }
        catch (IOException e) {
            logger.error("exception", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                logger.error("exception", (Throwable)e2);
            }
        }
        return imgBase64Str;
    }

    public static void createZoomImage(File sourceFile, File targetFile, int newWidth, int height) {
        try {
            Thumbnails.of((File[])new File[]{sourceFile}).size(newWidth, height).keepAspectRatio(true).outputFormat("jpg").toFile(targetFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createZoomImage(File sourceFile, File targetFile) {
        ImgEncodeUtil.createZoomImage(sourceFile, targetFile, 300, 300);
    }

    public static void createZoomImage(String sourceFile, String targetFile) {
        try {
            Thumbnails.of((String[])new String[]{sourceFile}).size(300, 300).keepAspectRatio(true).outputFormat("jpg").toFile(targetFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void createZoomImage(File sourceFile, File targetFile, int newWidth, float quality) {
        ImgEncodeUtil.createZoomImage(sourceFile, targetFile, newWidth, 300);
    }

    public static boolean isJPGImage(InputStream is) {
        boolean flag = false;
        try {
            int[] b = new int[4];
            b[0] = is.read();
            b[1] = is.read();
            is.skip(is.available() - 2);
            b[2] = is.read();
            b[3] = is.read();
            is.close();
            flag = b[0] == 255 && b[1] == 216 && b[2] == 255 && b[3] == 217;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return flag;
    }

    public static boolean isJPGImage(File file) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        return ImgEncodeUtil.isJPGImage(inputStream);
    }

    public static boolean isSupportImageType(File file, FileType ... fileTypes) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        return ImgEncodeUtil.isSupportImageType(inputStream, fileTypes);
    }

    public static boolean isSupportImageType(InputStream inputStream, FileType ... fileTypes) {
        FileType fileType = ImgEncodeUtil.getFileType(inputStream);
        for (FileType type : fileTypes) {
            if (!fileType.getValue().equals(type.getValue())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileType getFileType(InputStream is) {
        try {
            FileType[] fileTypes;
            byte[] src = new byte[28];
            is.read(src, 0, 28);
            StringBuilder stringBuilder = new StringBuilder("");
            if (src == null || src.length <= 0) {
                FileType fileType = null;
                return fileType;
            }
            for (int i = 0; i < src.length; ++i) {
                int v = src[i] & 0xFF;
                String hv = Integer.toHexString(v).toUpperCase();
                if (hv.length() < 2) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(hv);
            }
            for (FileType fileType : fileTypes = FileType.values()) {
                if (!stringBuilder.toString().startsWith(fileType.getValue())) continue;
                FileType fileType2 = fileType;
                return fileType2;
            }
            FileType[] fileTypeArray = null;
            return fileTypeArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return null;
    }
}

