/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.base.config;

import java.io.File;
import java.util.ArrayList;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.commons.lang3.StringUtils;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="${security.require-ssl:false}")
public class SSLConfig {
    private static final Logger log = LoggerFactory.getLogger(SSLConfig.class);
    @Value(value="${http.server.port:0}")
    private Integer httpPort;
    @Value(value="${server.port:8443}")
    private Integer httpsPort;
    @Value(value="${server.connection-timeout:0}")
    private Integer timeout;
    @Value(value="${security.allow.method:head}")
    private String allowMethod;
    public static String serverSslKeystore;
    public static String serverSslKeyStoreType;
    public static String serverSslKeyStorePassword;
    public static String serverSslKeyAlias;

    private boolean isAllowMethod(String method) {
        if (!StringUtils.isNotBlank((CharSequence)method)) {
            if (method.equalsIgnoreCase("post") || method.equalsIgnoreCase("get")) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)this.allowMethod)) {
                String[] methods;
                for (String m : methods = this.allowMethod.split(",")) {
                    if (!m.equalsIgnoreCase(method)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Value(value="${server.ssl.key-store-password:}")
    public void setServerSslKeyStorePassword(String serverSslKeyStorePassword) {
        SSLConfig.serverSslKeyStorePassword = StringUtils.isBlank((CharSequence)serverSslKeyStorePassword) ? "ZKTeco185***" : serverSslKeyStorePassword;
    }

    @Value(value="${server.ssl.keyStoreType:PKCS12}")
    public void setServerSslKeyStoreType(String serverSslKeyStoreType) {
        SSLConfig.serverSslKeyStoreType = serverSslKeyStoreType;
    }

    @Value(value="${server.ssl.keyAlias:}")
    public void setServerSslKeyAlias(String serverSslKeyAlias) {
        SSLConfig.serverSslKeyAlias = StringUtils.isBlank((CharSequence)serverSslKeyAlias) ? "1" : serverSslKeyAlias;
    }

    @Value(value="${server.ssl.key-store:}")
    public void setServerSslKeystore(String serverSslKeystore) {
        String defaultKeyStorePath = System.getProperty("user.dir") + File.separator + "ssl" + File.separator + "zk.p12";
        String keyStorePath = StringUtils.isBlank((CharSequence)serverSslKeystore) ? defaultKeyStorePath : serverSslKeystore;
        log.info(keyStorePath);
        SSLConfig.serverSslKeystore = keyStorePath;
    }

    @Bean
    public EmbeddedServletContainerFactory servletContainer() {
        System.setProperty("server.ssl.key-store", serverSslKeystore);
        System.setProperty("server.ssl.key-store-password", serverSslKeyStorePassword);
        System.setProperty("server.ssl.keyStoreType", serverSslKeyStoreType);
        System.setProperty("jdk.tls.ephemeralDHKeySize", "2048");
        TomcatEmbeddedServletContainerFactory tomcat = new TomcatEmbeddedServletContainerFactory(){

            protected void postProcessContext(Context context) {
                SecurityConstraint securityConstraint = new SecurityConstraint();
                securityConstraint.setUserConstraint("CONFIDENTIAL");
                SecurityCollection collection = new SecurityCollection();
                collection.addPattern("/*");
                ArrayList<String> methods = new ArrayList<String>();
                methods.add("HEAD");
                methods.add("PUT");
                methods.add("DELETE");
                methods.add("OPTIONS");
                methods.add("TRACE");
                methods.add("COPY");
                methods.add("SEARCH");
                methods.add("PROPFIND");
                methods.add("BOGUS");
                for (String method : methods) {
                    if (SSLConfig.this.isAllowMethod(method)) continue;
                    collection.addMethod(method);
                }
                securityConstraint.addCollection(collection);
                context.addConstraint(securityConstraint);
            }
        };
        if (this.timeout > 0) {
            tomcat.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(Connector connector) {
                    Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
                    protocol.setConnectionTimeout(SSLConfig.this.timeout.intValue());
                }
            }});
        }
        if (this.httpPort > 0) {
            tomcat.addAdditionalTomcatConnectors(new Connector[]{this.httpConnector()});
        }
        return tomcat;
    }

    @Bean
    public Connector httpConnector() {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setScheme("http");
        connector.setPort(this.httpPort.intValue());
        connector.setSecure(false);
        connector.setRedirectPort(this.httpsPort.intValue());
        if (this.timeout > 0) {
            Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
            protocol.setConnectionTimeout(this.timeout.intValue());
        }
        return connector;
    }
}

