/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective(script="ui/js/ZKComboTree.js")
public class ComboTree
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        boolean enableRTL = BeanUtil.enableRTL();
        Writer out = env.getOut();
        JSONObject jsonData = new JSONObject();
        BeanUtil.setParamsToJson(jsonData, params);
        String title = I18nUtil.i18nCode((String)BeanUtil.getParam(params, "title", ""), (Object[])new Object[0]);
        HTMLElement doc = Document.createElement();
        HTMLElement div = doc.div().addClass("search-combo-box").attr("title", title);
        if (params.get("hideLabel") == null) {
            if (params.get("required") != null) {
                title = title + "<span class='required'>*</span>";
            }
            HTMLElement label = div.label().text(title).addClass("search-label");
            if (params.get("labelWidth") != null) {
                label.width(params.get("labelWidth").toString());
            }
        }
        String id = BeanUtil.getParam(params, "id", "comboTree" + BeanUtil.getUUID());
        jsonData.put("id", (Object)id);
        JSONObject opt = (JSONObject)env.getCurrentNamespace().toMap().get("searchParams");
        if (opt != null) {
            List comboTrees = (List)opt.getObject("comboTrees", List.class);
            comboTrees.add(id);
        }
        div.div().addAttributesOnly(params).id(id).attr("title", title);
        if (enableRTL) {
            jsonData.put("enableRTL", (Object)true);
        }
        div.script().appendContent("new ZKUI.ComboTree(" + jsonData.toJSONString() + ");");
        out.write(doc.toString());
    }
}

